/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_extensions.h"
#include "test_common.h"

int simple(mx_endpoint_t ep, mx_endpoint_addr_t addr,
          int sync, int forget_send, int forget_recv)
{
  char a = 'a', b;
  mx_segment_t send_seg = { .segment_ptr = &a, .segment_length = 1 };
  mx_segment_t recv_seg = { .segment_ptr = &b, .segment_length = 1 };
  mx_request_t send_req, recv_req;
  int completed;
  mx_return_t ret;
  mx_status_t status;
  uint32_t result;

  printf("\nstarting a new test\n");
  completed = 0;
  b = 'z';

  ret = mx_irecv(ep, &recv_seg, 1, 0, 0, NULL, &recv_req);
  insist(ret == MX_SUCCESS);
  if (forget_recv) {
    printf("forgetting the recv request\n");
    ret = mx_forget(ep, &recv_req);
    insist(ret == MX_SUCCESS);
  }

  ret = (*(sync ? &mx_issend : &mx_isend))(ep, &send_seg, 1, addr, 0, NULL, &send_req);
  insist(ret == MX_SUCCESS);
  if (forget_send) {
    printf("forgetting the send request\n");
    ret = mx_forget(ep, &send_req);
    insist(ret == MX_SUCCESS);
  }

  while (1) {
    printf("waiting during 5 second in case something completes\n");
    ret = mx_wait_any(ep, 5000, 0, 0, &status, &result);
    insist(ret == MX_SUCCESS);
    if (result) {
      insist(status.code == MX_STATUS_SUCCESS);
      printf("got one completion\n");
      completed++;
    } else {
      printf("got nothing, stop waiting\n");
      break;
    }
  }
  printf("got %d completion (%d expected)\n\n", completed, 2-forget_recv-forget_send);
  insist(completed == 2-forget_recv-forget_send);
  insist(b == a);

  return 0;
}

int
main(int argc, char * argv[])
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  mx_return_t ret;
  uint64_t nic_id;
  uint32_t eid;

  ret = mx_init();
  insist(ret == MX_SUCCESS);

  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);

  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  mx_decompose_endpoint_addr(addr, &nic_id, &eid);
  insist(ret == MX_SUCCESS);

  ret = mx_connect(ep, nic_id, eid, 0, MX_INFINITE, &addr);
  insist(ret == MX_SUCCESS);

  simple(ep, addr, 1, 0, 0);
  simple(ep, addr, 1, 1, 1);
  simple(ep, addr, 0, 1, 0);
  simple(ep, addr, 0, 0, 1);

  ret = mx_close_endpoint(ep);
  insist(ret == MX_SUCCESS);

  ret = mx_finalize();
  insist(ret == MX_SUCCESS);

  return 0;
}
